/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager.Admin;

import ibm.nways.jdm.eui.ColumnLayout;
import java.awt.BorderLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCButton;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCLabel;
import jclass.bwt.JCList;
import jclass.bwt.JCTextField;

public class IdSelector
extends Panel
implements ItemSelectable,
JCActionListener,
JCItemListener {
    private static ResourceBundle adminRB = ResourceBundle.getBundle("ibm.nways.analysis.dpManager.Admin.AdminResources");
    private static final String NEW_BUTTON_LABEL = adminRB.getString("s_New");
    private static final String DELETE_BUTTON_LABEL = adminRB.getString("s_Delete");
    private JCList list;
    private JCButton newButton;
    private JCButton deleteButton;
    private JCTextField entryField;
    private ItemListener itemListener;
    private JCActionListener actionListener;

    public IdSelector(String string, boolean bl) {
        super(new BorderLayout());
        this.initialize(string, bl);
    }

    private void initialize(String string, boolean bl) {
        this.list = new JCList();
        this.list.setPreferredSize(200, 90);
        this.entryField = new JCTextField();
        this.entryField.setPreferredSize(300, 22);
        this.list.addItemListener(this);
        this.add("West", new JCLabel(string));
        this.add("Center", this.list);
        Panel panel = new Panel();
        panel.add(this.entryField);
        this.add("South", panel);
        if (bl) {
            this.newButton = new JCButton(NEW_BUTTON_LABEL);
            this.deleteButton = new JCButton(DELETE_BUTTON_LABEL);
            Panel panel2 = new Panel(new ColumnLayout(10));
            this.newButton.setInsets(new Insets(8, 8, 8, 8));
            this.deleteButton.setInsets(new Insets(8, 8, 8, 8));
            panel2.add(this.newButton);
            panel2.add(this.deleteButton);
            this.add("East", panel2);
            this.newButton.addActionListener(this);
            this.deleteButton.addActionListener(this);
        }
    }

    public Insets getInsets() {
        return new Insets(5, 5, 5, 5);
    }

    public void addId(String string) {
        this.list.addItem(string);
    }

    public void removeId(String string) {
        this.list.remove(string);
    }

    public void removeAllIds() {
        this.list.removeAll();
    }

    public String getItem(int n) {
        return (String)this.list.getItem(n);
    }

    public void select(String string) {
        this.list.select(string);
        this.list.makeVisible(this.list.getSelectedIndex());
    }

    public void select(int n) {
        this.list.select(n);
        this.list.makeVisible(n);
    }

    public int getItemCount() {
        return this.list.getItems().size();
    }

    public int getSelectedIndex() {
        int n = this.list.getSelectedIndex();
        if (n == -999) {
            n = -1;
        }
        return n;
    }

    public void addActionListener(JCActionListener jCActionListener) {
        this.actionListener = jCActionListener;
    }

    public void removeActionListener(JCActionListener jCActionListener) {
        if (this.actionListener == jCActionListener) {
            this.actionListener = null;
        }
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListener = itemListener;
    }

    public void removeItemListener(ItemListener itemListener) {
        if (this.itemListener == itemListener) {
            this.itemListener = null;
        }
    }

    public String getSelectedItem() {
        return this.entryField.getText().trim();
    }

    public void clearText() {
        this.entryField.setText("");
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (jCActionEvent.getSource() == this.newButton) {
            if (this.actionListener != null && this.entryField.getText().trim().length() > 0) {
                this.actionListener.actionPerformed(new JCActionEvent(this, 1001, NEW_BUTTON_LABEL));
                return;
            }
        } else if (jCActionEvent.getSource() == this.deleteButton && this.actionListener != null && this.entryField.getText().trim().length() > 0) {
            this.actionListener.actionPerformed(new JCActionEvent(this, 1001, DELETE_BUTTON_LABEL));
        }
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
        if (jCItemEvent.getSource() == this.list) {
            if (jCItemEvent.getStateChange() == 1) {
                this.entryField.setText((String)jCItemEvent.getItem());
                if (this.itemListener != null) {
                    this.itemListener.itemStateChanged(new ItemEvent(this, 701, jCItemEvent.getItem(), 1));
                    return;
                }
            } else if (jCItemEvent.getStateChange() == 2) {
                this.entryField.setText("");
            }
        }
    }

    public Object[] getSelectedObjects() {
        Object[] objectArray = new Object[]{this.getSelectedItem()};
        return objectArray;
    }
}

